<?php
/**
 * @package 	WordPress
 * @subpackage 	Medical Clinic
 * @version 	1.3.7
 * 
 * Admin Panel Scripts & Styles
 * Created by CMSMasters
 * 
 */


function medical_clinic_admin_register($hook) {
	global $pagenow;
	
	$screen = get_current_screen();
	
	
	wp_enqueue_style('wp-color-picker');
	
	wp_enqueue_script('wp-color-picker');
	
	wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', array(
		'clear' => 				esc_attr__('Clear', 'medical-clinic'),
		'clearAriaLabel' => 	esc_attr__('Clear color', 'medical-clinic'),
		'defaultLabel' => 		esc_attr__('Color value', 'medical-clinic'),
		'defaultString' => 		esc_attr__('Default', 'medical-clinic'),
		'defaultAriaLabel' => 	esc_attr__('Select default color', 'medical-clinic'),
		'pick' => 				esc_attr__('Select Color', 'medical-clinic'),
	) ); 
	
	wp_enqueue_script('wp-color-picker-alpha', get_template_directory_uri() . '/framework/admin/inc/js/wp-color-picker-alpha.js', array('jquery', 'wp-color-picker'), '3.0.4', true);
	
	
	wp_enqueue_style('medical-clinic-admin-icons-font', get_template_directory_uri() . '/framework/admin/inc/css/admin-icons-font.css', array(), '1.0.0', 'screen');
	
	wp_enqueue_style('medical-clinic-lightbox', get_template_directory_uri() . '/framework/admin/inc/css/jquery.cmsmastersLightbox.css', array(), '1.0.0', 'screen');
	
	if (is_rtl()) {
		wp_enqueue_style('medical-clinic-lightbox-rtl', get_template_directory_uri() . '/framework/admin/inc/css/jquery.cmsmastersLightbox-rtl.css', array(), '1.0.0', 'screen');
	}
	
	
	wp_enqueue_script('medical-clinic-uploader-js', get_template_directory_uri() . '/framework/admin/inc/js/jquery.cmsmastersUploader.js', array('jquery'), '1.0.0', true);
	
	wp_localize_script('medical-clinic-uploader-js', 'cmsmasters_admin_uploader', array( 
		'choose' => 				esc_attr__('Choose image', 'medical-clinic'), 
		'insert' => 				esc_attr__('Insert image', 'medical-clinic'), 
		'remove' => 				esc_attr__('Remove', 'medical-clinic'), 
		'edit_gallery' => 			esc_attr__('Edit gallery', 'medical-clinic') 
	));
	
	
	wp_enqueue_script('medical-clinic-lightbox-js', get_template_directory_uri() . '/framework/admin/inc/js/jquery.cmsmastersLightbox.js', array('jquery'), '1.0.0', true);
	
	wp_localize_script('medical-clinic-lightbox-js', 'cmsmasters_admin_lightbox', array( 
		'cancel' => 				esc_attr__('Cancel', 'medical-clinic'), 
		'insert' => 				esc_attr__('Insert', 'medical-clinic'), 
		'deselect' => 				esc_attr__('Deselect', 'medical-clinic'), 
		'choose_icon' => 			esc_attr__('Choose Icon', 'medical-clinic'), 
		'find_icons' => 			esc_attr__('Find icons', 'medical-clinic'), 
		'min_length' => 			esc_attr__('min 2 symbols', 'medical-clinic'), 
		'choose_font' => 			esc_attr__('Choose icons font', 'medical-clinic'), 
		'error_on_page' => 			esc_attr__("Error on page!\nReload page and try again.", 'medical-clinic') 
	));
	
	
	if ( 
		$hook == 'post.php' || 
		$hook == 'post-new.php' || 
		$hook == 'widgets.php' || 
		$hook == 'term.php' || 
		$hook == 'edit-tags.php' || 
		$hook == 'nav-menus.php' || 
		str_replace('cmsmasters-settings-element', '', $screen->id) != $screen->id 
	) {
		wp_enqueue_style('medical-clinic-icons', get_template_directory_uri() . '/css/fontello.css', array(), '1.0.0', 'screen');
		
		wp_enqueue_style('medical-clinic-icons-custom', get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/css/fontello-custom.css', array(), '1.0.0', 'screen');
	}
	
	
	if ( 
		$hook == 'widgets.php' || 
		$hook == 'nav-menus.php' 
	) {
		wp_enqueue_media();
	}
	
	
	wp_enqueue_style('medical-clinic-admin-styles', get_template_directory_uri() . '/framework/admin/inc/css/admin-theme-styles.css', array(), '1.0.0', 'screen');
	
	if (is_rtl()) {
		wp_enqueue_style('medical-clinic-admin-styles-rtl', get_template_directory_uri() . '/framework/admin/inc/css/admin-theme-styles-rtl.css', array(), '1.0.0', 'screen');
	}
	
	
	wp_enqueue_script('medical-clinic-admin-scripts', get_template_directory_uri() . '/framework/admin/inc/js/admin-theme-scripts.js', array('jquery'), '1.0.0', true);
	
	
	if ($hook == 'widgets.php') {
		wp_enqueue_style('medical-clinic-widgets-styles', get_template_directory_uri() . '/framework/admin/inc/css/widgets-styles.css', array(), '1.0.0', 'screen');
		
		wp_enqueue_script('medical-clinic-widgets-scripts', get_template_directory_uri() . '/framework/admin/inc/js/widgets-scripts.js', array('jquery'), '1.0.0', true);
	}
}

add_action('admin_enqueue_scripts', 'medical_clinic_admin_register');

add_action('admin_enqueue_scripts', 'cmsmasters_composer_icons');

