<?php 
/**
 * @package 	WordPress
 * @subpackage 	Medical Clinic
 * @version 	1.1.4
 * 
 * Custom Single Comment Template
 * Created by CMSMasters
 * 
 */


function medical_clinic_mytheme_comment($comment, $args, $depth) {
    ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
        <div id="comment-<?php comment_ID(); ?>" class="comment-body cmsmasters_comment_item">
			<figure class="cmsmasters_comment_item_avatar">
				<?php 
					echo get_avatar($comment->comment_author_email, 60, get_option('avatar_default')) . "\n"; 
					
					edit_comment_link(esc_attr__('Edit', 'medical-clinic'), '', '');
				?>
			</figure>
			<div class="comment-content cmsmasters_comment_item_cont">
				<div class="cmsmasters_comment_item_cont_info">
					<?php 
					comment_reply_link(array_merge($args, array( 
						'depth' => $depth, 
						'max_depth' => $args['max_depth'], 
						'reply_text' => esc_attr__('Reply', 'medical-clinic') 
					)));
					?>
					<?php 
						echo '<abbr class="published cmsmasters_comment_item_date cmsmasters-icon-calendar-3" title="' . get_comment_date() . '">' . 
							get_comment_date() .
						'</abbr>';
					?>
					<h6 class="fn cmsmasters_comment_item_title"><?php echo get_comment_author_link(); ?></h6>
				</div>
				<div class="cmsmasters_comment_item_content">
					<?php 
					comment_text();
					
					if ($comment->comment_approved == '0') {
						echo '<p>' . 
							'<em>' . esc_html__('Your comment is awaiting moderation.', 'medical-clinic') . '</em>' . 
						'</p>';
					}
					?>
				</div>
			</div>
        </div>
    <?php 
}

