<?php
/**
 * @package 	WordPress
 * @subpackage 	Medical Clinic
 * @version 	1.4.0
 *
 * TGM-Plugin-Activation 2.6.1
 * Created by CMSMasters
 *
 */


require_once(get_template_directory() . '/framework/class/class-tgm-plugin-activation.php');


if (!function_exists('medical_clinic_register_theme_plugins')) {

function medical_clinic_register_theme_plugins() {
	$plugins = array(
		array(
			'name'					=> esc_html__('CMSMasters Content Composer', 'medical-clinic'),
			'slug'					=> 'cmsmasters-content-composer',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-content-composer.zip',
			'required'				=> true,
			'version'				=> '2.5.5',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name'					=> esc_html__('CMSMasters Custom Fonts', 'medical-clinic'),
			'slug'					=> 'cmsmasters-custom-fonts',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-custom-fonts.zip',
			'required'				=> true,
			'version'				=> '1.0.1',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name'					=> esc_html__('CMSMasters Mega Menu', 'medical-clinic'),
			'slug'					=> 'cmsmasters-mega-menu',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-mega-menu.zip',
			'required'				=> true,
			'version'				=> '1.2.9',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name'					=> esc_html__('CMSMasters Importer', 'medical-clinic'),
			'slug'					=> 'cmsmasters-importer',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-importer.zip',
			'required'				=> true,
			'version'				=> '1.0.8',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name' 					=> esc_html__('LayerSlider WP', 'medical-clinic'),
			'slug' 					=> 'LayerSlider',
			'source'				=> get_template_directory() . '/theme-vars/plugins/LayerSlider.zip',
			'required'				=> false,
			'version'				=> '7.14.1',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name' 					=> esc_html__('Revolution Slider', 'medical-clinic'),
			'slug' 					=> 'revslider',
			'source'				=> get_template_directory() . '/theme-vars/plugins/revslider.zip',
			'required'				=> false,
			'version'				=> '6.7.29',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name'					=> esc_html__('Envato Market', 'medical-clinic'),
			'slug'					=> 'envato-market',
			'source'				=> 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
			'required'				=> false
		), 
		array( 
			'name'					=> esc_html__('Timetable', 'medical-clinic'), 
			'slug'					=> 'timetable', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/timetable.zip', 
			'required'				=> false, 
			'version'				=> '7.4', 
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		),
		array(
			'name'					=> esc_html__('GDPR Cookie Consent', 'medical-clinic'),
			'slug'					=> 'cookie-law-info',
			'required'				=> false
		),
		array(
			'name'					=> esc_html__('HubSpot – CRM, Email Marketing, Live Chat, Forms & Analytics', 'medical-clinic'),
			'slug'					=> 'leadin',
			'required'				=> false
		),
		array(
			'name' 					=> esc_html__('WooCommerce', 'medical-clinic'),
			'slug' 					=> 'woocommerce',
			'required'				=> false
		),
		array(
			'name' 					=> esc_html__('Contact Form 7', 'medical-clinic'),
			'slug' 					=> 'contact-form-7',
			'required' 				=> false
		),
		array(
			'name'					=> esc_html__('MailPoet 3', 'medical-clinic'),
			'slug'					=> 'mailpoet',
			'required'				=> false
		)
	);


	$config = array(
		'id' => 			'medical-clinic',
		'menu' => 			'theme-required-plugins',
		'strings' => array(
			'page_title' => 	esc_html__('Theme Required & Recommended Plugins', 'medical-clinic'),
			'menu_title' => 	esc_html__('Theme Plugins', 'medical-clinic'),
			'return' => 		esc_html__('Return to Theme Required & Recommended Plugins', 'medical-clinic')
		)
	);


	tgmpa($plugins, $config);
}

}

add_action('tgmpa_register', 'medical_clinic_register_theme_plugins');
